USE BMSWAITINGLIST
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_UID UNIQUEIDENTIFIER,  @START_DATE DATETIME
--@START_DATE - INITIAL START DATE
SET @START_DATE = '20110210' 
SET @FACILITY_CODE = 'BYN'
SELECT @FACILITY_UID = E.IDENTIFIER
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

DECLARE @COUNT_BMS_ACTIVE_VISN_WL INT, @COUNT_LOCAL_DATABASE_ACTIVE_WL INT,
		@COUNT_BMS_FINALIZED_VISN_WL INT, @COUNT_LOCAL_DATABASE_FINALIZED_WL INT, @COUNT_SPECIALTY_NOT_FOUND INT
		

SELECT @COUNT_BMS_ACTIVE_VISN_WL = COUNT(*) FROM BMS.dbo.TRANSFER_REQ AS REQ
INNER JOIN BMS.dbo.ACT AS A_REQ ON A_REQ.ID = REQ.ACT_ID
LEFT OUTER JOIN BMS.dbo.ACT AS A ON A.PARENT_ACT_ID = A_REQ.ID
WHERE A.ID IS NULL AND REQ.FACILITY_UID = @FACILITY_UID

SELECT @COUNT_LOCAL_DATABASE_ACTIVE_WL = COUNT(*)
FROM VISN_Bed_Control_Waiting 
WHERE VAHOSP = @FACILITY_CODE AND EVENTDT >= @START_DATE AND DISPDT IS NULL AND LEN(SSN)=9

CREATE TABLE #VISTA_SPECIALTY(CODE NVARCHAR(500), DISPLAY_NAME NVARCHAR(400))
INSERT INTO #VISTA_SPECIALTY(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM BMS_EVS.dbo.conceptProperty
WHERE codingSchemeName = 'VistaSpecialty'

IF @COUNT_BMS_ACTIVE_VISN_WL = @COUNT_LOCAL_DATABASE_ACTIVE_WL
	BEGIN
	SELECT 'ACTIVE VISN WL SUCCESSFULLY UPDATED'
	END
ELSE
	BEGIN
	SELECT 'IN LOCAL DATABASE (CLS. 3) ARE ' + CAST(@COUNT_LOCAL_DATABASE_ACTIVE_WL AS NVARCHAR(MAX)) + ' ACTIVE WAINTING LIST' 
	SELECT 'IN BMS DATABASE (CLS. 1) ARE ' + CAST(@COUNT_BMS_ACTIVE_VISN_WL AS NVARCHAR(MAX)) + ' ACTIVE WAINTING LIST'
	
	SELECT @COUNT_SPECIALTY_NOT_FOUND = COUNT(*)
	FROM VISN_Bed_Control_Waiting 
	WHERE VAHOSP = @FACILITY_CODE AND EVENTDT >= @START_DATE AND DISPDT IS NULL AND LEN(SSN)=9
	AND SPECNAMETEXT NOT IN (SELECT DISPLAY_NAME FROM #VISTA_SPECIALTY)
	
	SELECT CAST(@COUNT_SPECIALTY_NOT_FOUND AS NVARCHAR(MAX)) + ' NOT FOUND IN BMS_EVS'
	

	END
	
SELECT @COUNT_BMS_FINALIZED_VISN_WL = COUNT(*) FROM BMS.dbo.TRANSFER_REQ AS REQ
INNER JOIN BMS.dbo.ACT AS A_REQ ON A_REQ.ID = REQ.ACT_ID
INNER JOIN BMS.dbo.ACT AS A ON A.PARENT_ACT_ID = A_REQ.ID
INNER JOIN BMS.dbO.TRANSFER_EVN AS EVN ON EVN.ACT_ID = A.ID
WHERE REQ.FACILITY_UID = @FACILITY_UID

SELECT @COUNT_LOCAL_DATABASE_FINALIZED_WL = COUNT(*)
FROM VISN_Bed_Control_Waiting 
WHERE VAHOSP = @FACILITY_CODE AND EVENTDT >= @START_DATE AND DISPDT IS NOT NULL AND LEN(SSN)=9

IF @COUNT_BMS_FINALIZED_VISN_WL = @COUNT_LOCAL_DATABASE_FINALIZED_WL
	BEGIN
	SELECT 'FINALIZED VISN WL SUCCESSFULLY UPDATED'
	END
ELSE
	BEGIN
	SELECT 'IN LOCAL DATABASE (CLS. 3) ARE ' + CAST(@COUNT_LOCAL_DATABASE_FINALIZED_WL AS NVARCHAR(MAX)) + ' FINALIZED WAINTING LIST' 
	SELECT 'IN BMS DATABASE (CLS. 1) ARE ' + CAST(@COUNT_BMS_FINALIZED_VISN_WL AS NVARCHAR(MAX)) + ' FINALIZED WAINTING LIST'
	
	SET @COUNT_SPECIALTY_NOT_FOUND = NULL
	SELECT @COUNT_SPECIALTY_NOT_FOUND = COUNT(*)
	FROM VISN_Bed_Control_Waiting 
	WHERE VAHOSP = @FACILITY_CODE AND EVENTDT >= @START_DATE AND DISPDT IS NOT NULL AND LEN(SSN)=9
	AND SPECNAMETEXT NOT IN (SELECT DISPLAY_NAME FROM #VISTA_SPECIALTY)
	
	SELECT CAST(@COUNT_SPECIALTY_NOT_FOUND AS NVARCHAR(MAX)) + ' NOT FOUND IN BMS_EVS'
	END
	
DROP TABLE #VISTA_SPECIALTY